Test_BasicJoints = class()

function Test_BasicJoints:init()
    self.title = "basic joints"
    self.unit = (HEIGHT / 2) * 0.1
end

function Test_BasicJoints:setup()
    self.lab = PhysicsLab()  
    self.lab:makePetrieDish()    
    
    --all the bodies
    self:createBigCircleGroup()
    self:createBallAndStick()
    self:createBoxAndHat()
    
    --all the joints
    self.lab:pointThatTwoBodiesRevolveAround(self.bigCircle.x, self.bigCircle.y, self.bigCircle, self.skinnyRect)
    self.lab:barBetweenBodies(self.skinnyRect, self.lilCircle, self.skinnyRect.position - vec2(0, self.unit * 0.5), self.lilCircle.position)
    local horizontalRail = self.lab:keepBodiesOnRailDefinedByPoints(self.innerCircle, self.box, self.box.position, vec2(1,0))
    local diagonalRail = self.lab:keepBodiesOnRailDefinedByPoints(self.bigCircle, self.anchor, self.bigCircle.position, vec2(0.25, 0.5))
    self.lab:weldBodiesTogether(self.box, self.lilHat, vec2(self.box.x, self.box.y), self.box.position)
    
    --limits on how far the rails go
    diagonalRail.enableLimit = true
    diagonalRail.upperLimit = self.unit * 2.65
    diagonalRail.lowerLimit = self.unit * -3.75
    horizontalRail.enableLimit = true
    horizontalRail.upperLimit = self.unit * 1.5
    horizontalRail.lowerLimit = horizontalRail.upperLimit * -1
    
    print("The big circle and rect share a REVOLUTE joint, the rect and ball a DISTANCE joint, the square and little hat a WELD joint, and the big circle and square are on 'rails' or PRISMATIC joints.\n\nPhysicsLab gives you helpfully-named functions for all of these.")
end

function Test_BasicJoints:draw()
    self.innerCircle.position = self.bigCircle.position
    self.lab:draw()
end

function Test_BasicJoints:touched(touch)
    self.lab:touched(touch)
end

function Test_BasicJoints:collide(contact)
    self.lab:collide(contact)
end

function Test_BasicJoints:cleanup()
    self.lab:clear()
end

function Test_BasicJoints:createBigCircleGroup()
    self.anchor = self.lab:circleAt(WIDTH*0.4, HEIGHT * 0.6, self.unit * 0.2)
    self.anchor.type = STATIC
    self.bigCircle = self.lab:circleAt(self.anchor.x, self.anchor.y, self.unit * 1.8)
    self.innerCircle = self.lab:circleAt(self.anchor.x, self.anchor.y, self.unit * 1.75)
    self.innerCircle.type = KINEMATIC
    self.lab.categoryManager:makeIgnoreAll(self.bigCircle)
    self.lab.categoryManager:makeIgnoreAll(self.anchor)
    self.lab.categoryManager:makeIgnoreAll(self.innerCircle)
end

function Test_BasicJoints:createBallAndStick()
    self.skinnyRect = self.lab:boxAt(self.bigCircle.x, self.bigCircle.y * 0.8, self.unit * 1.05, self.unit * 2.9)
    self.lilCircle = self.lab:circleAt(self.bigCircle.x, self.bigCircle.y * 0.5, self.unit * 0.75)
end

function Test_BasicJoints:createBoxAndHat()
    local halfHatWidth, hatHeight, halfBrimWidth, brimHeight = self.unit * 0.6,  self.unit * 0.65, self.unit * 0.8, self.unit * 0.35
    self.lilHat = self.lab:polygonAt(WIDTH * 0.75, self.anchor.y + (self.unit * 1.25), {
        vec2(-halfHatWidth, hatHeight),
        vec2(halfHatWidth, hatHeight),
        vec2(halfHatWidth, brimHeight),
        vec2(halfBrimWidth, brimHeight),
        vec2(halfBrimWidth, 0),
        vec2(-halfBrimWidth, 0),
        vec2(-halfBrimWidth, brimHeight),
        vec2(-halfHatWidth, brimHeight),
    })
    self.box = self.lab:boxAt(WIDTH * 0.75, self.anchor.y, self.unit * 2.5, self.unit * 2.5)
end